<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Provider extends Model 
{

    protected $table = 'providers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id');
    protected $fillable = array('name', 'identity_number', 'commercial_registration_number_or_work_permit', 'country_code', 'phone', 'password', 'lat', 'lng', 'city', 'map_desc', 'cell_phone_maintenance', 'store_services', 'mobile_maintenance', 'active', 'is_blocked', 'is_approved', 'is_notify', 'image', 'email', 'lang', 'socket_id', 'bio', 'stc_number');

    public function providerWorkingDays()
    {
        return $this->hasMany('App\Models\Provider');
    }

    public function rates()
    {
        return $this->morphMany('App\Models\Rate', 'rateable');
    }

    public function products()
    {
        return $this->hasMany('App\Models\Product');
    }

    public function providerBanks()
    {
        return $this->hasOne('App\Models\ProviderBank');
    }

}